/*--------------------------------------------------------------------
File: OtherSensorFunction.c
Description: OtherSansorFunction
Function:
---------------------------------------------------------------------*/
#include "typedef.h"
#include "m6759.h"
#include "io.h"
#include "Reg_5608u.h"
#include "I2C.h"
#include "usbdev.h"
#include "const.h"
#include "dsp_5606.h"
#include "Kernel.h"
#include "uvc.h"
#include "common.h"
#include "interpreter.h"
#include "RomTable.h"
#include "Romfix.h"
#include "system.h"


//
extern CBYTE cbDescCreateTabHs[];
extern CBYTE cbDescCreateTabFs[];
extern CBYTE cbSizeTableHs[];
extern CBYTE cbSizeTableFs[];
extern CBYTE cbGamma_New[];
extern CBYTE cbWhiteBalanceTab[];

//
extern CBYTE cbSensorPowerOn[];
extern CBYTE cbSensorPowerOff[];
extern CBYTE cbItprSensorInit[];

//
extern CBYTE cbItprAwbEn[];
extern CBYTE cbItprAwbDis[];
extern CBYTE cbItpr50HzMap0[];
extern CBYTE cbItpr60HzMap0[];
extern CBYTE cbItpr50HzMap1[];
extern CBYTE cbItpr60HzMap1[];

//Other Setting
extern CBYTE cbItprVga30fps[];

//Fixed at top: 0xE000
CWORD cfInterpreterTab[]={

	//Load Table
	(&cbDescCreateTabHs),		//ITPR_LOAD_VS_DESC_HS
	(&cbDescCreateTabFs),		//ITPR_LOAD_VS_DESC_FS
	(&cbSizeTableHs),			//ITPR_LOAD_SIZETAB_HS
	(&cbSizeTableFs),			//ITPR_LOAD_SIZETAB_FS

	//
#if(_EXT_LOAD_GAMMA_)
	(&cbGamma_New),				//ITPR_LOAD_GAMMA
#else
	(0x0000),					//ITPR_LOAD_GAMMA	//use default
#endif

	//
#if(_EXT_LOAD_WB_TAB_)
	(&cbWhiteBalanceTab),		//ITPR_LOAD_WB_TAB
#else
	(0x0000),					//ITPR_LOAD_WB_TAB
#endif

	//Sensor Interpreter
	(0x0000),				//ITPR_SEN_POWER_ON
	(0x0000),				//ITPR_SEN_POWER_OFF
#if(_EXT_SEN_INIT_)
	(&cbItprSensorInit),	//ITPR_SEN_INIT
#else
	(0x0000),				//ITPR_SEN_INIT
#endif

	//PropertyCheck Interpreter
#if(_EXT_LOAD_WB_TAB_)	//101209
	(&cbItprAwbEn),			//ITPR_AWB_EN
	(&cbItprAwbDis),		//ITPR_AWB_DIS
#else
	(0x0000),		//ITPR_AWB_EN
	(0x0000),		//ITPR_AWB_DIS
#endif
#if(_EXT_SET_PLF_)	//101222
	(&cbItpr50HzMap0),		//ITPR_PLF_50HZ[0]
	(&cbItpr60HzMap0),		//ITPR_PLF_60HZ[0]
	(&cbItpr50HzMap1),		//ITPR_PLF_50HZ[1]
	(&cbItpr60HzMap1),		//ITPR_PLF_60HZ[1]
#else
	(0x0000),		//ITPR_PLF_50HZ[0]
	(0x0000),		//ITPR_PLF_60HZ[0]
	(0x0000),		//ITPR_PLF_50HZ[1]
	(0x0000),		//ITPR_PLF_60HZ[1]
#endif

	//Other Setting
	(&cbItprVga30fps),		//0x0F: HS - VGA 30fps
};

//----------------------------

//
// Desc Table
//
code unsigned char cbDescCreateTabHs[]={

(DESC_NEW_METHOD|DESC_YUV|DESC_COLOR_MATCH), //|DESC_CAPTURE_METHOD_2),	//b0:YUV, b1:MJPG, b2~b3:capture method, b4:color match, b5:trigger support, b6:trigger usage b7:use new method
0x04,	//[3-0]:gbYuvDesNum, [7-4]:gbYuvStillSizeNum
0x00,	//[3-0]:gbMjpgDesNum, [7-4]:gbMjpgStillSizeNum
0x01,	//[3-0]:gbFormatTypeYuvPriority, [7-4]:gbFormatTypeMjpgPriority

//If Support Method 3
//0,	//gbMethod3EpAddr	//method 3 not support

//If Support Color matching
0x01,0x01,0x04,	//gbColorMatchPara[0-2]

//If gbYuvDesNum!=0, assign gpYuvFormat
IMG_XY_RATIO(0, 0), IMG_COMPRESS_RATE(0),
IMG_W(640), IMG_H(480),		0x02, FPSx2(30),FPSx2(15),
//IMG_W(352), IMG_H(288),		0x02, FPSx2(30),FPSx2(15),
IMG_W(320), IMG_H(240),		0x02, FPSx2(30),FPSx2(15),
//IMG_W(176), IMG_H(144),		0x02, FPSx2(30),FPSx2(15),
IMG_W(160), IMG_H(120),		0x02, FPSx2(30),FPSx2(15),
IMG_W(640), IMG_H(360),		0x02, FPSx2(30),FPSx2(15),
//If gbYuvStillSizeNum!=0, assign gpYuvStillFormat
//IMG_W(640), IMG_H(480),

//If gbMjpgDesNum!=0, assign gpMjpgFormat
//IMG_XY_RATIO(0, 0), IMG_COMPRESS_RATE(0),
//IMG_W(640), IMG_H(480),		0x03, FPSx2(30), FPSx2(20), FPSx2(10),

//If gbMjpgStillSizeNum!=0, assign gpMjpgStillFormat
//IMG_W(640), IMG_H(480),
};

code unsigned char cbDescCreateTabFS[]={

(DESC_NEW_METHOD|DESC_YUV|DESC_COLOR_MATCH),	//b0:YUV, b1:MJPG, b2~b3:capture method, b4:color match, b5:trigger support, b6:trigger usage b7:use new method
0x01,	//[3-0]:gbYuvDesNum, [7-4]:gbYuvStillSizeNum
0x00,	//[3-0]:gbMjpgDesNum, [7-4]:gbMjpgStillSizeNum
0x01,	//[3-0]:gbFormatTypeYuvPriority, [7-4]:gbFormatTypeMjpgPriority

//If Support Method 3
//0,	//gbMethod3EpAddr	//method 3 not support

//If Support Color matching
0x01,0x01,0x04,	//gbColorMatchPara[0-2]

//If gbYuvDesNum!=0, assign gpYuvFormat
IMG_XY_RATIO(0, 0), IMG_COMPRESS_RATE(0),
IMG_W(320), IMG_H(240),		0x01, FPSx2(5),

//If gbYuvStillSizeNum!=0, assign gpYuvStillFormat
//IMG_W(640), IMG_H(480),

//If gbMjpgDesNum!=0, assign gpMjpgFormat
//IMG_XY_RATIO(0, 0), IMG_COMPRESS_RATE(0),
//IMG_W(640), IMG_H(480),		0x04, FPSx2(30), FPSx2(25), FPSx2(20),FPSx2(10),

//If gbMjpgStillSizeNum!=0, assign gpMjpgStillFormat
//IMG_W(640), IMG_H(480),
};

CBYTE cbSizeTableHs[]=
{
	0x03,	//SizeShift:	Max 2048

	//Map: Mapping to sensor initial table
	//ExtTab: Sensor Size table (ITPR index)
	//IniTab: Sensor Initial table (ITPR index)

//	W				H				Map		ExtTab
	4,	//SubLen
	Sized8(640),	Sized8(480),	0x00,	0x00,
//	Sized8(352),	Sized8(288),	0x00,	0x00,
	Sized8(320),	Sized8(240),	0x00,	0x00,
//	Sized8(176),	Sized8(144),	0x00,	0x00,
	Sized8(160),	Sized8(120),	0x00,	0x00,
	Sized8(640),	Sized8(360),	0x00,	0x00,

//	W.Sen			H.Sen			IniTab	SENO	CPR|SEN
	//---Clock setting---
	// 	SENO: [7]:CLKEN,[6:5]:CLKSEL([00]12M,[01]48M,[10]60M,[11]80M),[4]:DIVEN,[3:0]:DIV
	//		12M-0x80,16M-0xB1,20M-0xD1,24M-0xB0,30M-0xD0,40M-0xF0,48M-0xA0,60M-0xC0
	//	CPR|SEN: [7:4]:CPR,[3:0]:SEN
	//		12M-8,24M-9,30M-A,48M-B,60M-C,80M-D
	Sized8(640),	Sized8(480),	0x00,	0xB0,	0xAA,	//24/30/30
};

CBYTE cbSizeTableFs[]=
{
	0x03,	//SizeShift:	Max 2048

	//Map: Mapping to sensor initial table
	//ExtTab: Sensor Size table (ITPR index)
	//IniTab: Sensor Initial table (ITPR index)

//	W				H				Map		ExtTab
	1,	//SubLen
	Sized8(320),	Sized8(240),	0x00,	0x00,

//	W.Sen			H.Sen			IniTab	SENO	CPR/SEN
	//---Clock setting---
	// 	SENO: [7]:CLKEN,[6:5]:CLKSEL([00]12M,[01]48M,[10]60M,[11]80M),[4]:DIVEN,[3:0]:DIV
	//		12M-0x80,16M-0xB1,20M-0xD1,24M-0xB0,30M-0xD0,40M-0xF0,48M-0xA0,60M-0xC0
	//	CPR|SEN: [7:4]:CPR,[3:0]:SEN
	//		12M-8,24M-9,30M-A,48M-B,60M-C,80M-D
	Sized8(640),	Sized8(480),	0x00,	0xBA,	0x99,	//4/24/24
};

//----------------------------
//
#if(_EXT_LOAD_GAMMA_)
CBYTE cbGamma_New[18*3]=	
{
//	Default: linear
	0x00,0x04,0x08,0x10,0x18,0x20,0x28,0x30,0x40,0x50,0x60,0x70,0x80,0x90,0xA0,0xC0,0xE0,0xFF,
	
//	Min Gamma: r = 1.82
	0x00,0x00,0x00,0x02,0x03,0x06,0x09,0x0c,0x15,0x1f,0x2b,0x39,0x49,0x5a,0x6d,0x98,0xc9,0xFF,

//	Max Gamma: r = 0.55
	0x00,0x1a,0x26,0x38,0x46,0x51,0x5c,0x66,0x77,0x87,0x95,0xa2,0xaf,0xba,0xc5,0xda,0xed,0xFF
};
#endif

#if(_EXT_LOAD_WB_TAB_)
CBYTE cbItprAwbEn[]={
//I2cSensorWrite(0x22,I2cSensorRead(0x22)|0x02);		//AWB enable
/*(OR_EQUAL_STATE|PAIR1),
SENSOR_TAG,0x22,
VALUE_B_TAG,0x02,
*/
PARSING_COMPLETE,
};

CBYTE cbItprAwbDis[]={
//I2cSensorWrite(0x10,0x15);		//AWB disable
/*(AND_EQUAL_STATE|PAIR1),
SENSOR_TAG,0x22,
VALUE_B_TAG,0xFD,
*/
PARSING_COMPLETE,
};

CBYTE cbWhiteBalanceTab[]={
//
0x02,	//[7-4]:ValueShift [3-0]:Number

//
0x5C,	// B Gain addr
0x70,0x55,0x43,0x30,	//B Gain		[2500,4000,5500,7000]
0x5A,	// R Gain addr
0x30,0x48,0x5a,0x68,	//R Gain		[2500,4000,5500,7000]
};
#endif

#if(_EXT_SET_PLF_)
CBYTE cbItpr50HzMap0[]={
SENSOR_STATE,
0x00,
END_TAG, 	//end tag


PARSING_COMPLETE,
};

CBYTE cbItpr60HzMap0[]={
SENSOR_STATE,
0x00,
END_TAG, 	//end tag


PARSING_COMPLETE,
};

CBYTE cbItpr50HzMap1[]={
PARSING_COMPLETE,
};

CBYTE cbItpr60HzMap1[]={
PARSING_COMPLETE,
};
#endif

#if(_EXT_SEN_INIT_)
CBYTE cbItprSensorInit[] = {
SENSOR_STATE,
0x00,	//SubLen=0	---> till end tag
//-------------------------------------------
//slave address
//0x62 for write
//0x63 for read
//[Sensor Setting]

//END
//[END]
//-------------------------------------------
0x15, 0x02, //  ;02->12 vclk synchronous
0x09, 0x02, //
0x13, 0x00, //
0x01, 0x16, //
0x02, 0x21, //
0x8C, 0x02, //
0x8D, 0x64, //
0x87, 0x18, //
0x13, 0x07, //
0x1E, 0x30, //  L,30;R,00
0x1F, 0x20, //
0x11, 0x80, //
0x35, 0x44, //
0x65, 0x40, //
0x66, 0x40, //
0x36, 0x05, //
0x37, 0xF6, //
0x38, 0x46, //
0x9B, 0xF6, //
0x9C, 0x46, //
0xBC, 0x01, //
0xBD, 0xF6, //
0xBE, 0x46, //
0x70, 0xbF, //9f
0x72, 0xf1, //8f
0x73, 0xff,  ////0x00,   //0x5F, // EDGE Control
0x74, 0x2f, //
0x75, 0x0E, //
0x77, 0x90, //
0x7A, 0x0E, //
0x7B, 0x28, //
0x2F, 0xf6, //
0x16, 0x03, //
0x24, 0x73,  //0x98, //  ;88->98 AE high threshold
0x25, 0x83,  //0x88, //  ;78->88 AE low  threshold
0x94, 0x0A, //
0x3F, 0xB0, //  ;c0->e0 gamma offset
0x40, 0x58, //
0x41, 0x54, //
0x42, 0x4E, //
0x43, 0x44, //
0x44, 0x3e, //
0x45, 0x39, //
0x46, 0x35, //
0x47, 0x31, //
0x48, 0x2e, //
0x49, 0x2b, //
0x4B, 0x29, //
0x4C, 0x27, //
0x4E, 0x23, //
0x4F, 0x20, //
0x50, 0x1e, //
0x51, 0x1d, //
0x52, 0x36, //
0x53, 0x19, //
0x54, 0x0f, //
0x55, 0x00, //  ;brightness  add
0x57, 0x82, //
0x58, 0x91, //
0x59, 0x70, //
0x5A, 0x6b, //
0x5B, 0x05, //
0x5D, 0x9D, //
0x5C, 0x1E, //
0x60, 0x30, //  ;20->2b bad pixel correction
0xB0, 0x00, //  ;00->ef saturation
0xB1, 0xa0, //  ;c0  cb saturation
0xB2, 0xb0, //  ;b0  cr saturation
0xB3, 0x8A, //
0x82, 0x14, //
0x83, 0x23, //
0x84, 0x1A, //
0x85, 0x20, //
0x9A, 0x23, //
0x86, 0x3f, //
0x98, 0x18, //
0x96, 0xA6, //
0x97, 0x0C, //
0x89, 0x01, //
0x8A, 0xCB, //
0x6A, 0x81, //
0x23, 0x77, //
0xA0, 0x03, //
0x06, 0xE0, //
0xA1, 0x31, //
0xA2, 0x0d, //  ;16->18  blue gain
0xA3, 0x26, //  ;26->28
0xA4, 0x09, //  ;        red gain
0xA5, 0x25,  //0x22,  //0x20, //  ;23->22
0xA6, 0x06, //
0xA7, 0x7e, //
0xA8, 0x80, //
0xA9, 0x23, //
0xAA, 0x23, //
0xAB, 0x23, //
0xAC, 0x2C, //
0xAD, 0xF0, //
0xC8, 0x18, //
0xC9, 0x20, //
0xCA, 0x17, //
0xCB, 0x1F, //
0xAF, 0x16, //
0xC5, 0x18, //
0xC6, 0x10, //
0xC7, 0x20, //
0xAE, 0x03, //
0xCD, 0x40, //
0xEE, 0x4C, //
0x80, 0x05, //
0x56, 0x48, //  ;40->45 contrast
0x8E, 0x08, //
0x8F, 0x12, //
0x3A, 0x00, //

0x61, 0xe3,
0x79, 0xc8,
0x76, 0x00,
0xe0, 0x06,
0x16, 0x03,

0x3c, 0x24, //0x00,
0x2f, 0xf6,
0x7a, 0x0e,
0xb0, 0x00, //0xe0,
0x2b, 0x00,
0x9d, 0x99,
0x86, 0x34, //0x24,
//0x70, 0xaf,

END_TAG,//end tag
PARSING_COMPLETE,
};
#endif

//-------------------
// Other Setting
//-------------------
CBYTE cbItprVga30fps[] = {
SENSOR_STATE,
0x00,	//SubLen=0	---> till end tag
//-------------------------------------------
//slave address
//0x42 for write
//0x43 for read
//0xfe, 0x01,
//END
//[END]
//-------------------------------------------
END_TAG, 	//end tag

PARSING_COMPLETE,
};
//
CBYTE cbExtCodeEnd[]={0xFF};
